a = 1;           % Separation distance between capacitor plates
w = 1;           % Width of capacitor plates

n  = 10;         % Number of unknowns
nh = round(n/2); % Number of elements on each plate
h  = a/nh;       % Length of the elements

% X-coordinates for starting and ending points
xs = zeros(1,n);   
xe = zeros(1,n);   
xs(1:nh)       = linspace(0,a-h,nh); 
xs(nh+1:2*nh)  = linspace(0,a-h,nh);
xe             = xs + h;

% Y-coordinates for starting and ending points
ys = zeros(1,n);   
ye = zeros(1,n);
ys(1:nh)       = 0.5*w;
ys(nh+1:2*nh)  = -0.5*w;
ye             = ys;

% Potential for the elements
V              = zeros(1,n);    
V(1:nh)        = 0.5;
V(nh+1:2*nh)   = -0.5;

% Solve the electrostatic problem
[charge, sigma] = MoM2D(xs, ys, xe, ye, V);
C = sum(charge(1:nh))
